/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateProjection.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFeature.h"
#include "CApplication.h"


//  Projects the specified profile on to the part and return the
//	newly created projection.

HRESULT CreateProjection(ISketch *pInputSketch, ISet *pFaces, long direction, long extent, long profileSide, double taperAngle, long materialStatus, CString projectionName, IProjection **pProjection)
{

	START_METHOD("CreateProjection")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument * activePart = NULL;
	IPartOthers *part2 = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;
	IDispatch *pDisp = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	// perform operation to create projection
	IProjection *projection = NULL;
	status = (GetCLASS(Projection))->CreateProjection(pDesign, pInputSketch, CAST(IObjectOrSet, pFaces), direction, extent, profileSide, taperAngle, materialStatus, 0, &projection);
	CHECK_RETURN_STATUS(status)

	IOperation *operation = CAST(IOperation, projection);
	status = operation->SetName(projectionName.AllocSysString());
	CHECK_RETURN_STATUS(status)

	// return the pointer
	*pProjection = projection;
	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	END_METHOD("CreateProjection")
}
